import java.awt.event.KeyEvent;

import javax.swing.JOptionPane;

public class GridEventProcessor extends DrawObjectEventProcessor
{
	@Override
	public void TryProcessUserKeyboardAction(MainWindow.GUIElements GUIElements, KeyEventProcessor KeyEventProcessor, MouseEventProcessor MouseEventProcessor, ObjectStorage ObjectStorage, IOProgram IOProgram)
	{
		if (!(KeyboardEventsToBeProcessed(GUIElements)))
			return;

		// ****************************************************************
		// h (assign Hormone to Neuron)
		if (UNDEFINED(FillTextField) &&
			KeyEventProcessor.IsKeyCodePressed(KeyEvent.VK_H) &&
			KeyEventProcessor.IsControlPressed())
		{
			if (GUIElements.GetMainWindow().hasFocus())
			{
				if (UNDEFINED(NearObject) && NOT(MultiSelectionExisting) && IOProgram.IsExecuted())
				{
					String HormoneStrengthManipulationCommand = JOptionPane.showInputDialog("Enter 'HormoneName=[-100...0...100]' to adjust factor for flow in Neuron from 0.0 to 2.0");
					if (HormoneStrengthManipulationCommand != null && HormoneStrengthManipulationCommand.length() >= 1)
					{
						String HormoneName = Neuron.ExtractHormoneName(HormoneStrengthManipulationCommand);
						double HormoneStrength = Neuron.ExtractHormoneStrength(HormoneStrengthManipulationCommand);

						// TODO: the following might not be effective because of an "already-done-check",
						// which needs to be reset manually (done in Simulation):

						ObjectStorage.UpdateHormoneStrengthForAll(HormoneName, HormoneStrength);
						
						GUIElements.GetMainWindow().DoRedraw(); // maybe done anyway by running simulation, but we need to get sure
					}
				}
			}
		}

		return;
	}

	@Override
	public void TryProcessUserMouseAction(MainWindow.GUIElements GUIElements, KeyEventProcessor KeyEventProcessor, MouseEventProcessor MouseEventProcessor, ObjectStorage ObjectStorage, IOProgram IOProgram)
	{
		if (!(MouseEventsToBeProcessed(GUIElements)))
			return;

		return;
	}
}
